<?php
include 'db.php';

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['barcodeData'])) {
    // Get barcode data from user input (e.g., SKU)
    $barcodeData = $_POST['barcodeData'];

    // Debug: Check if the barcode data is being received
    var_dump($_POST);

    // Function to generate a QR code image based on the input data
    function generateQRCode($data, $size = 150) {
        // QR code version (21x21 grid) for a simple QR code
        $matrixSize = 21;
        
        // Create a basic QR Code image (placeholder for actual QR encoding)
        // QR codes usually have error correction and complex encoding, but we are simplifying it
        $qrCode = array_fill(0, $matrixSize, array_fill(0, $matrixSize, 0));

        // Simplified method to encode the data (Note: this won't fully follow the QR standards)
        // Generate a binary string from the data (CRC32 hash of input data)
        $binaryData = str_pad(decbin(crc32($data)), $matrixSize * $matrixSize, '0', STR_PAD_LEFT);
        
        // Fill the QR code matrix based on binary data
        for ($i = 0; $i < $matrixSize; $i++) {
            for ($j = 0; $j < $matrixSize; $j++) {
                // Place black (1) and white (0) squares in the QR grid
                $qrCode[$i][$j] = $binaryData[$i * $matrixSize + $j] == '1' ? 0 : 1; // Black is 1, white is 0
            }
        }

        // Create an image from the QR code matrix
        $image = imagecreatetruecolor($size, $size);
        $white = imagecolorallocate($image, 255, 255, 255); // White background
        $black = imagecolorallocate($image, 0, 0, 0); // Black squares

        // Fill the image background with white
        imagefill($image, 0, 0, $white);

        // Draw the QR code squares (each cell in the grid is represented as a square)
        $cellSize = $size / $matrixSize;
        for ($i = 0; $i < $matrixSize; $i++) {
            for ($j = 0; $j < $matrixSize; $j++) {
                if ($qrCode[$i][$j] == 1) {
                    // Draw a black square (QR code "black" cell)
                    imagefilledrectangle($image, $j * $cellSize, $i * $cellSize, ($j + 1) * $cellSize, ($i + 1) * $cellSize, $black);
                }
            }
        }

        // Generate a unique filename for the QR code image
        $timestamp = time();
        $imagePath = 'barcodes/qrcode_' . $timestamp . '.png';

        // Save the image to the file
        imagepng($image, $imagePath);

        // Free up memory
        imagedestroy($image);

        return $imagePath;
    }

    // Generate the QR code image
    $imagePath = generateQRCode($barcodeData);

    // Insert QR code data into MySQL
    $sql = "INSERT INTO barcodes (barcode_data, barcode_image) VALUES ('$barcodeData', '$imagePath')";

    if ($conn->query($sql) === TRUE) {
        echo "QR Code generated and saved successfully!";
    } else {
        echo "Error: " . $conn->error;
    }
} else {
    echo "No data received!";
}

// Close connection
$conn->close();
?>
